'##############################################################
'Feuchtigkeitssensor_SLAVEID_aendern.bas
'
'
'Das Programm liest einen Temperatur und Feuchtigkeitssensor vom Typ HYT271
'oder Typ HYT939 ber I2C aus und gibt die Werte ber RS232 aus
'
'Wenn ein USB Modul an RN-AVR UNIVERSAL angesteckt oder eingeltet wurde
'dann wird das Ergebnis  ber USB zu einem virtuellen COM Port bertragen
'und kann auch mit allen Programmen oder Terminalprogramm empfangen werden
'
' (c) Frank roboternetz.de
'Bezug: www.robotikhardware.de
'Weitere Beispiele auf DVD oder im www.Roboternetz.de und rn-wissen.de
'######################################################################



Declare Function HYT_Test() As Integer
Declare Function HYT_Auslesen() As Integer
Declare Sub HYT_WerteAusgeben()



$programmer = 12                                            'MCS USB  (Zeile weglassen wenn anderer Programmer)
$prog &HFF , &HFF , &HD9 , &HFE                             'Fusebits richtig programmieren (Quarz ein,Jtag aus)

$regfile = "m644pdef.dat"
$framesize = 32
$swstack = 32
$hwstack = 64

$crystal = 8000000                                          'Quarzfrequenz

$baud = 9800                                                'Baudrate (bertragungsgeschwindigkeit)
Baud = 9800

Config Scl = Portc.0                                        'Ports fuer IIC-Bus
Config Sda = Portc.1





Config Pind.6 = Output                                      'LED
Led1 Alias Portd.6




Dim Tmp As Byte
Dim I As Byte
Dim I2c_addr_old As Byte                                    '8 bit I2C write address at program start
Dim I2c_addr_old_r As Byte                                  '8 bit I2C read address at program start
Dim I2c_addr_new As Byte                                    'new 8 bit I2C write address
Dim I2c_addr_new_r As Byte                                  'new 8 bit I2C read address
Dim Cmd_status As Byte                                      'Status byte in command mode
Dim Cmd_hbyte As Byte                                       'MSB data byte in command mode
Dim Cmd_lbyte As Byte                                       'LSB data byte in command mode
Dim Lbyte1 As Byte                                          'LSB data byte in normal mode for humidity
Dim Hbyte1 As Byte                                          'MSB data byte in normal mode for humidity
Dim Lbyte2 As Byte                                          'LSB data byte in normal mode for temperature
Dim Hbyte2 As Byte                                          'HSB data byte in normal mode for temperature
Dim Word1 As Word
Dim Word2 As Word
Dim Humidity As Single
Dim Temperature As Single
Dim Ha As String * 8
Dim Ta As String * 8

Config Portc.2 = Output                                     'This Pin is used as power Supply

I2c_addr_old = &H50                                         '7-bit Address: 28 default
'-------------------------------------------------------------------------------
'The variable I2c_addr_new contains the desired 8-bit I2C-address
I2c_addr_new = &H38                                         '7-bit Address: 1C
'-------------------------------------------------------------------------------
I2c_addr_new_r = I2c_addr_new + 1

Portc.2 = 0
wait 5

I2c_addr_old_r = I2c_addr_old + 1


Portc.2 = 1                                                 'power on
Waitms 2                                                    'command window (3-10ms) after power on reset

i2cinit

I2cstart
I2cwbyte I2c_addr_old
I2cwbyte &HA0                                               'enter command mode
I2cwbyte &H00
I2cwbyte &H00
I2cstop
Waitms 1

If Err = 1 Then
   Print "Error: no ACK for entering command mode"
   End
   Else
   Print "Command mode entered"
End If

I2cstart
I2cwbyte I2c_addr_old
I2cwbyte &HB0                                               'get revision
I2cwbyte &H00
I2cwbyte &H00
I2cstop
Waitms 1

I2cstart
I2cwbyte I2c_addr_old_r
I2crbyte Cmd_status , Ack                                   'read status, diagnostic and response bits
I2crbyte Cmd_lbyte , Nack                                   'read revision
I2cstop
Waitms 1

If Cmd_status <> &H81 Then
   Print "Status error while getting revision! Statusbyte: " ; Bin(cmd_status)
   End
Else
   Print "Success! -> Revision: " ; Hex(cmd_lbyte)
End If

I2cstart
I2cwbyte I2c_addr_old
I2cwbyte &H1C                                               'Command Read EEprom
I2cwbyte &H00
I2cwbyte &H00
I2cstop
Waitms 1
I2cstart
I2cwbyte I2c_addr_old_r
I2crbyte Cmd_status , Ack                                   'read EEprom
I2crbyte Cmd_hbyte , Ack
I2crbyte Cmd_lbyte , Nack
I2cstop
Waitms 1
Print "HYT address (7-bit): " ; Hex(cmd_lbyte) ; "  ";
Shift Cmd_lbyte , Left                                      'convert 7-bit address to 8-bit
Print "I2C address (8-bit): " ; Hex(cmd_lbyte)
Print "Now changing I2C address"
I2cstart
I2cwbyte I2c_addr_old
I2cwbyte &H5C                                               'Command write EEprom
I2cwbyte &H00
Cmd_lbyte = I2c_addr_new
Shift Cmd_lbyte , Right                                     '7-bit address is needed
I2cwbyte Cmd_lbyte                                          'write new i2c address
I2cstop
Waitms 100

Portc.2 = 0                                                 'power off
Print "Reset and verify new address"
Print "Power off HYT221 and wait for a second"
Wait 1
Print "Now switch power on and try to enter the command mode during command window"       '
Portc.2 = 1                                                 'power on

Waitms 1                                                    'command window (3-10ms) after power on reset

I2cstart
I2cwbyte I2c_addr_new
I2cwbyte &HA0                                               'enter command mode
I2cwbyte &H00
I2cwbyte &H00
I2cstop
Waitms 1

I2cstart
I2cwbyte I2c_addr_new                                       'Verify
I2cwbyte &H1C                                               'Command Read EEprom
I2cwbyte &H00
I2cwbyte &H00
I2cstop
Waitms 1
I2cstart
I2cwbyte I2c_addr_new_r
I2crbyte Cmd_status , Ack                                   'read eeprom
I2crbyte Cmd_hbyte , Ack
I2crbyte Cmd_lbyte , Nack
I2cstop
Waitms 1
Shift Cmd_lbyte , Left
If Cmd_lbyte = I2c_addr_new Then
Print "New I2C address (8-bit),(verified): " ; Hex(cmd_lbyte)
Else
Print "Error: changing I2C address not successfull !" ; Hex(cmd_lbyte)
End If

Print
Print "Leave command mode and enter normal mode"
I2cstart
I2cwbyte I2c_addr_new                                       '
I2cwbyte &H80                                               'transition to normal mode
I2cwbyte &H00
I2cwbyte &H00
I2cstop
Waitms 1

Print "Now read humidity and temperature with new address"
I2cstart
I2cwbyte I2c_addr_new                                       'Measurement request command
I2cstop
Wait 1
I2cstart
I2cwbyte I2c_addr_new_r                                     'Data fetch command
I2crbyte Hbyte1 , Ack                                       'read humidity data
I2crbyte Lbyte1 , Ack
I2crbyte Hbyte2 , Ack                                       'read temperature data
I2crbyte Lbyte2 , Nack
I2cstop

Hbyte1 = Hbyte1 And &H3F                                    '  clear status bits (Bit15:CMode, bit14: Stale)
Word1 = Hbyte1
Shift Word1 , Left , 8
Word1 = Word1 Or Lbyte1
Humidity = Word1 / 163.84
Ha = Fusing(humidity , "#.#")
Print "Humidity:    " ; Ha ; "%"

Word2 = Hbyte2
Shift Word2 , Left , 8
Lbyte2 = Lbyte2 And &HFC                                    'mask bit0 and bit1
Word2 = Word2 Or Lbyte2
Temperature = Word2
Temperature = Temperature / 65536
Temperature = Temperature * 165
Temperature = Temperature - 40
Ta = Fusing(temperature , "#.#")
Print "Temperature: " ; Ta ; "C"
Print
Print "Program terminated !"

do
loop